// server theme resources.
if( SERVER ) then
	// resources
	resource.AddFile( "materials/themes/blue-plastic/highlight.vmt" );
	resource.AddFile( "materials/themes/blue-plastic/highlight.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/highlightBottom.vmt" );
	resource.AddFile( "materials/themes/blue-plastic/highlightBottom.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/close.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/minus.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/plus.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/close.vmt" );
	resource.AddFile( "materials/themes/blue-plastic/minus.vmt" );
	resource.AddFile( "materials/themes/blue-plastic/plus.vmt" );
	resource.AddFile( "materials/themes/generic/resizer.vmt" );
	resource.AddFile( "materials/themes/generic/resizer.vtf" );

	return;
	
end


// Register a theme.
Theme	=	AppFramework:RegisterTheme( "Blue-Plastic" );

// materials
local matHighlight		= surface.GetTextureID( "themes/blue-plastic/highlight" );
local matHighlightBottom	= surface.GetTextureID( "themes/blue-plastic/highlightBottom" );

// set colors
Theme.colors['window_face'] 	= Color( 189, 199, 231, 255 );
Theme.colors['title']		= Color( 0, 0, 0, 255 );
Theme.colors['text']		= Color( 0, 0, 0, 255 );
Theme.colors['window_face_sub']	= Color( 133, 148, 197, 255 );
Theme.colors['window_face_subdark']	= Color( 90, 100, 160, 255 );
Theme.colors['border_dark']	= Color( 42, 48, 82, 255 ); //Color( 78, 97, 159, 255 );
Theme.colors['window_border']	= Color( 78, 97, 159, 255 );
Theme.colors['button_face']	= Color( 179, 189, 221, 255 );
Theme.colors['border_light']	= Color( 180, 189, 220, 255 ); //Color( 217, 224, 246, 255 );
//Theme.colors['selection']	= Color( 95, 127, 202, 70 );
Theme.colors['selection']	= Color( 159, 179, 223, 128 );


// set icons
Theme.icons['close_button']	= "themes/blue-plastic/close";
Theme.icons['plus_icon']	= "themes/blue-plastic/plus";
Theme.icons['minus_icon']	= "themes/blue-plastic/minus";
Theme.icons['resizer']		= "themes/generic/resizer";

// set fonts.
Theme.fonts['title']		= "Default";
Theme.fonts['text']		= "DefaultSmall";

// theme draw frame.
function Theme:DrawFrame( x, y, width, height, draw_type, data )
	// remove any textures.
	draw.NoTexture();
	
	// window frame.
	if( draw_type == FRAME_WINDOW ) then
		// draw the shadow.
		surface.SetDrawColor( 0, 0, 0, 128 );
		surface.DrawRect(
			x, y,
			width, height
		);
		
		// draw the border.
		surface.SetDrawColor(
			self.colors['window_border'].r,
			self.colors['window_border'].g,
			self.colors['window_border'].b,
			self.colors['window_border'].a
		);
		surface.DrawRect(
			x + 1, y + 1,
			width - 2, height - 2
		);
		
		// draw blue canvas bit..
		surface.SetDrawColor(
			self.colors['window_face'].r,
			self.colors['window_face'].g,
			self.colors['window_face'].b,
			self.colors['window_face'].a
		);
		surface.DrawRect(
			x + 3, y + 3,
			width - 6, height - 6
		);
		
		// draw the interior portion.
		surface.SetDrawColor( 201, 209, 235, 255 );
		surface.DrawRect( x + 24, y + 3, width - 48, height - 6 );
	
		// draw the highlight.
		surface.SetTexture( matHighlight );
		surface.SetDrawColor( 255, 255, 255, 255 );
		surface.DrawTexturedRect(
			x + 3, y + 3,
			width - 6, 48
		);
		
		surface.SetTexture( matHighlightBottom );
		surface.DrawTexturedRect(
			x + 3, y + height - ( 48 + 3 ),
			width - 6, 48
		);
		
		// draw divider lines.
		draw.NoTexture();
		surface.SetDrawColor( 0, 0, 0, 80 );
		surface.DrawRect( x + 3, y + 32, width - 6, 1 );
		
		surface.SetDrawColor( 255, 255, 255, 80 );
		surface.DrawRect( x + 3, y + 33, width - 6, 1 );
		
		surface.SetDrawColor( 0, 0, 0, 80 );
		surface.DrawRect( x + 3, y + height - 33, width - 6, 1 );
		
		surface.SetDrawColor( 255, 255, 255, 80 );
		surface.DrawRect( x + 3, y + height - 32, width - 6, 1 );
		
	// inset frame
	elseif( draw_type == FRAME_INSET ) then
		// draw background
		if( data && type( data ) == "table" ) then
			surface.SetDrawColor(
				data.r,
				data.g,
				data.b,
				data.a
			);
		else
			surface.SetDrawColor(
				self.colors[data or 'window_face_sub'].r,
				self.colors[data or 'window_face_sub'].g,
				self.colors[data or 'window_face_sub'].b,
				self.colors[data or 'window_face_sub'].a
			);
		end
		surface.DrawRect(
			x + 2, y + 2,
			width - 4, height - 4
		);
		
		
		// draw dark borders
		surface.SetDrawColor(
			self.colors['border_dark'].r,
			self.colors['border_dark'].g,
			self.colors['border_dark'].b,
			self.colors['border_dark'].a
		);
		
		// top.
		surface.DrawLine(
			x + 2, y + 2, 
			x + width - 2, y + 2
		);
		
		// left
		surface.DrawLine(
			x + 2, y + 2,
			x + 2, y + height - 2
		);
		
		
		// draw light borders
		surface.SetDrawColor(
			self.colors['border_light'].r,
			self.colors['border_light'].g,
			self.colors['border_light'].b,
			self.colors['border_light'].a
		);
		
		// right
		surface.DrawLine(
			x + width - 2, y + 2,
			x + width - 2, y + height - 2
		);
		
		// bottom.
		surface.DrawLine(
			x + 2, y + height - 2,
			x + width - 2, y + height - 2
		);
		
	// outset frame
	elseif( draw_type == FRAME_OUTSET ) then
		// draw background
		if( data && type( data ) == "table" ) then
			surface.SetDrawColor(
				data.r,
				data.g,
				data.b,
				data.a
			);
		else
			surface.SetDrawColor(
				self.colors[data or 'window_face_sub'].r,
				self.colors[data or 'window_face_sub'].g,
				self.colors[data or 'window_face_sub'].b,
				self.colors[data or 'window_face_sub'].a
			);
		end
		surface.DrawRect(
			x + 2, y + 2,
			width - 4, height - 4
		);
		
		
		// draw dark borders
		surface.SetDrawColor(
			self.colors['border_light'].r,
			self.colors['border_light'].g,
			self.colors['border_light'].b,
			self.colors['border_light'].a
		);
		
		// top.
		surface.DrawLine(
			x + 2, y + 2, 
			x + width - 2, y + 2
		);
		
		// left
		surface.DrawLine(
			x + 2, y + 2,
			x + 2, y + height - 2
		);
		
		
		// draw light borders
		surface.SetDrawColor(
			self.colors['border_dark'].r,
			self.colors['border_dark'].g,
			self.colors['border_dark'].b,
			self.colors['border_dark'].a
		);
		
		// right
		surface.DrawLine(
			x + width - 2, y + 2,
			x + width - 2, y + height - 2
		);
		
		// bottom.
		surface.DrawLine(
			x + 2, y + height - 2,
			x + width - 2, y + height - 2
		);
	end
end

